# -*- coding: utf-8 -*-
"""
Created on Wed Nov 04 19:54:25 2015

"""
import numpy as np

def AdvectionOnly(AMass, AVelocity, AArea, ADomain):
    x_values = ADomain.X.InclusiveRange()
    time_values = ADomain.Time.InclusiveRange() 

    assert len(x_values)==len(time_values)
    y_length = ADomain.Y.NumberOfSteps()
   
    delta_x = ADomain.X.Step
    
    Co = AMass/(AArea*delta_x)
            
    C = np.zeros((len(x_values), y_length, len(time_values)), float)

    for x_index in range(len(x_values)):
        x = x_values[x_index]        
        for t_index in range(len(time_values)):
            t = time_values[t_index]
            
            if np.isclose(x, t * AVelocity):
                C[x_index,:,t_index] = Co
                    
    return C